# PriorityQueue Demo: Sorting 2D Points

## 1) Objective

Demonstrate Java’s **`PriorityQueue`** by sorting points:

- Primary key: **x** ascending (left → right)
- Tie-break: **y** ascending (bottom → up)

Input: `(0,0) (2,2) (1,0) (1,1) (1,2)`
Output: `(0,0) (1,0) (1,1) (1,2) (2,2)`

---

## 2) Introducing `PriorityQueue`

`PriorityQueue<E>` is a heap-backed structure that always exposes the **minimum** element (by natural order or a provided **`Comparator`**).

- Insertion: `O(log n)`
- Removal of min: `O(log n)`
- Peek: `O(1)`
  We supply a custom **`Comparator<Point>`** to define the ordering (x, then y).

---

## 3) Implementation

**Files**

- `Point.java`: simple point implementation with `x`, `y`, getters/setters, and `toString()`.
- `PointsComparator.java`:

  ```java
  public int compare(Point p1, Point p2) {
    if (p1.getX() != p2.getX()) return p1.getX() - p2.getX(); // x asc
    return p1.getY() - p2.getY();                              // y asc
  }
  ```

- `Main.java` (`pqSort`):

  1. **Insertion**: add all points into `PriorityQueue<Point> pq = new PriorityQueue<>(new PointsComparator());`
  2. **Selection**: repeatedly remove the min and place into `sortedPoints`.

Note:

- Overall complexity: **`O(n log n)`** for n points.

---

## 4) Possible Extensions

1. **New ordering rule** (e.g., by distance from origin)

2. **Use a `for` loop to empty the queue**
